/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.server.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.nio.file.Path;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import potionstudios.byg.BYG;
import potionstudios.byg.client.KillClient;
import potionstudios.byg.config.BYGConfigHandler;
import potionstudios.byg.config.ConfigVersionTracker;
import potionstudios.byg.mixin.access.CommandSourceStackAccess;
import potionstudios.byg.util.FileUtils;
import potionstudios.byg.util.ModPlatform;
import potionstudios.byg.util.ServerKillCountDown;

public class UpdateConfigsCommand {
    private static int warnings = 0;
    private static final long COUNTDOWN_LENGTH = 1200L;
    public static final String COMMAND_STRING = "update_configs";
    public static final String UPDATE_STRING = "update";
    public static final String DISMISS_STRING = "dismiss";
    public static final String UPDATE_COMMAND = "/byg update_configs update";
    public static final String DISMISS_COMMAND = "/byg update_configs dismiss";
    public static final String BACKUP_PATH = "\".../config/byg/backups\"";
    public static final class_2561 UPDATE_COMPONENT = class_2564.method_10885((class_2561)class_2561.method_43471((String)"byg.command.updateconfig.update").method_27692(class_124.field_1060).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, UPDATE_COMMAND)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43469((String)"byg.command.updateconfig.update.hover", (Object[])new Object[]{class_2561.method_43470((String)BACKUP_PATH).method_27692(class_124.field_1078)}).method_27692(class_124.field_1061)))));
    public static final class_2561 DISMISS_UPDATE_COMPONENT = class_2564.method_10885((class_2561)class_2561.method_43471((String)"byg.command.updateconfig.dismiss").method_27692(class_124.field_1054).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, DISMISS_COMMAND))));
    public static final class_5250 CONTACT_SERVER_OWNER = class_2561.method_43471((String)"byg.command.updateconfig.contactserverowner");
    public static final class_5250 PLAYER_WARNING = class_2561.method_43471((String)"byg.command.updateconfig.warnplayers");
    public static final class_5250 SERVER_KILL_PLAYER_NOTIFICATION = class_2561.method_43471((String)"byg.command.updateconfig.notifyplayersservershutdown");
    public static final class_5250 GAME_CLOSE_WARNING = class_2561.method_43471((String)"byg.command.updateconfig.warngameclose");

    public static ArgumentBuilder<class_2168, ?> register() {
        String argName = "action";
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)COMMAND_STRING).requires(UpdateConfigsCommand::lambda$register$2)).then(class_2170.method_9244((String)argName, (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> class_2172.method_9253((String[])new String[]{UPDATE_STRING, DISMISS_STRING}, (SuggestionsBuilder)sb)).executes(cs -> {
            class_1657 player;
            class_2168 stack = (class_2168)cs.getSource();
            MinecraftServer server = stack.method_9211();
            class_2165 commandSource = ((CommandSourceStackAccess)cs.getSource()).byg_getSource();
            ConfigVersionTracker configVersionTracker = new ConfigVersionTracker(6);
            if (ConfigVersionTracker.getConfig().configVersion() == 6) {
                stack.method_9226((class_2561)class_2561.method_43471((String)"byg.command.updateconfig.configsuptodate"), true);
                return 1;
            }
            boolean isSinglePlayerOwner = commandSource instanceof class_1657 && server.method_19466((player = (class_1657)commandSource).method_7334());
            boolean isServerConsole = commandSource instanceof MinecraftServer;
            if (!isSinglePlayerOwner && !isServerConsole) {
                stack.method_9213((class_2561)CONTACT_SERVER_OWNER);
                BYG.logWarning("BYG's configs are outdated, run \"/byg update_configs update\" to dismiss this warning");
                return 0;
            }
            String argument = (String)cs.getArgument(argName, String.class);
            if (argument.equalsIgnoreCase(UPDATE_STRING)) {
                switch (warnings) {
                    case 0: {
                        stack.method_9213((class_2561)GAME_CLOSE_WARNING.method_27692(class_124.field_1067));
                        ++warnings;
                        break;
                    }
                    case 1: {
                        for (class_3222 serverPlayer : server.method_3760().method_14571()) {
                            serverPlayer.method_7353((class_2561)PLAYER_WARNING.method_27692(class_124.field_1054), false);
                        }
                        stack.method_9213((class_2561)GAME_CLOSE_WARNING.method_27692(class_124.field_1067));
                        ++warnings;
                        break;
                    }
                    case 2: {
                        for (class_3222 serverPlayer : server.method_3760().method_14571()) {
                            serverPlayer.method_7353((class_2561)SERVER_KILL_PLAYER_NOTIFICATION.method_27692(class_124.field_1061), false);
                        }
                        ((ServerKillCountDown)server).setKillCountdown(1200L, isSinglePlayerOwner);
                        ++warnings;
                        break;
                    }
                    default: {
                        warnings = 0;
                        break;
                    }
                }
            } else if (argument.equalsIgnoreCase(DISMISS_STRING)) {
                ConfigVersionTracker.getConfig(configVersionTracker, true);
            }
            return 1;
        }));
    }

    public static void backupAndKillGameInstance(MinecraftServer server, ConfigVersionTracker configVersionTracker, boolean isSinglePlayerOwner) {
        UpdateConfigsCommand.backupConfigs(configVersionTracker);
        if (server.method_3724() && isSinglePlayerOwner) {
            KillClient.kill();
        } else {
            server.method_3747(false);
        }
    }

    public static void backupConfigs(ConfigVersionTracker configVersionTracker) {
        Path directory = ModPlatform.INSTANCE.configPath();
        ConfigVersionTracker.getConfig(configVersionTracker, true);
        Path backUpPath = FileUtils.backUpDirectory(directory);
        FileUtils.deleteDirectory(directory, path -> !path.equals(backUpPath) && (!path.toFile().isDirectory() || path.toFile().listFiles().length <= 0));
        BYGConfigHandler.loadAllConfigs(true, true);
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ boolean lambda$register$2(class_2168 stack) {
        commandSource = ((CommandSourceStackAccess)stack).byg_getSource();
        if (!(commandSource instanceof class_1657)) ** GOTO lbl-1000
        player = (class_1657)commandSource;
        if (stack.method_9211().method_19466(player.method_7334())) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        isSinglePlayerOwner = v0;
        isServerConsole = commandSource instanceof MinecraftServer;
        return isSinglePlayerOwner != false || isServerConsole != false;
    }
}

